// SPDX-License-Identifier: MIT

function showLoader() {
    document.getElementById("loading").style.visibility = "visible";
}

function hideLoader() {
    document.getElementById("loading").style.visibility = "hidden";
}

deleteFlag = false;
deleteText = '';
function deleteHandler(val) {
    deleteText = val ? val : '本当に削除しますか？';
    deleteFlag = true;
}

function onsubmitHandler() {
    if (deleteFlag) {
        deleteFlag = false;
        if (!window.confirm(deleteText)) {
            return false;
        }
    }
    showLoader();
    return true;
}


// When returning to the browser back, hide loader.
window.addEventListener('pageshow', function (event) {
    if (event.persisted) {
        window.location.reload();
    }
});

function fillNWStatBar(placeHolder, data) {
    if (data.startsWith("<!DOCTYPE html>")) {
        document.open();
        document.write(data);
        document.close();
        return;
    }
    placeHolder.innerHTML = data;
}

const pollNetworkStat = async () => {
    nwstats = document.querySelector("div[name='nwstats']")
    if (nwstats) {
        const response = await fetch('/nwstatbar');
        const data = await response.text();
        fillNWStatBar(nwstats, data);
        setTimeout(pollNetworkStat, 2000);
    }
}

window.addEventListener('load', (event) => {
    if (document.querySelector("div[name='nwstats']")) {
        setTimeout(pollNetworkStat, 100);
    }
});
