// SPDX-License-Identifier: MIT

use axum::{
    extract::Request,
    middleware::Next,
    response::{IntoResponse, Redirect, Response},
};
use tower_sessions::Session;

pub trait LoggedIn {
    async fn logged_in(&self) -> bool;
}

impl LoggedIn for Session {
    async fn logged_in(self: &Session) -> bool {
        self.get::<bool>("login")
            .await
            .unwrap_or(Some(false))
            .unwrap_or(false)
    }
}

pub async fn check_auth(session: Session, request: Request, next: Next) -> Response {
    // Allow everything in debug mode
    if !cfg!(debug_assertions) && !session.logged_in().await {
        return Redirect::to("/").into_response();
    }
    next.run(request).await
}
