// SPDX-License-Identifier: MIT

use anyhow::Result;

use crate::common::{self, exec_command_no_script};

#[derive(Clone, Debug)]
pub struct HardwareConfig {
    pub has_wwan: bool,
    pub product: String,
}

impl HardwareConfig {
    pub async fn load() -> Self {
        let product = get_product()
            .await
            .unwrap_or_else(|_| "unknown".to_string());
        HardwareConfig {
            has_wwan: has_wwan(),
            product,
        }
    }
}

fn has_wwan() -> bool {
    cfg!(debug_assertions) || common::wwan_module().is_some()
}

async fn get_product() -> Result<String> {
    let output = exec_command_no_script(&["device-info", "-p"]).await?;
    Ok(String::from_utf8(output.stdout)?)
}
