#!/bin/sh -e
# SPDX-License-Identifier: MIT

CON_NAME="$1"
SSID="$1"
SECURITY="$2"
PASSWORD="$3"
INTERFACE="$4"
METHOD="$5"

trap catch ERR

while [[ $# -gt 0 ]];
do
	case "$1" in
		"-a")
			shift
			IP_ADDR="$1" ;;
		"-g")
			shift
			GATEWAY_ADDR="$1" ;;
		"-d")
			shift
			DNS_ADDR="$1" ;;
		"--connect")
			CONNECT="$CON_NAME" ;;
		*)
			;;
	esac
	shift
done

catch() {
	if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
		nmcli con del "$CON_NAME"
		persist_file -r /etc/NetworkManager/system-connections
	fi
	echo "Could not set up wlan connection." >&2
}

if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
	set -- nmcli con mod "$CON_NAME" ssid "$SSID" wifi-sec.key-mgmt "$SECURITY" wifi-sec.psk "$PASSWORD"
else
	set -- nmcli con add con-name "$CON_NAME" type wifi ifname "$INTERFACE" \
		ssid "$SSID" wifi-sec.key-mgmt "$SECURITY" wifi-sec.psk "$PASSWORD"
fi

if [ "$METHOD" = "auto" ]; then
	set -- "$@" ipv4.method auto
else
	set -- "$@" ipv4.method manual ipv4.addresses "$IP_ADDR" ipv4.gateway "$GATEWAY_ADDR"
fi

if [ -n "$DNS_ADDR" ]; then
	set -- "$@" ipv4.dns "$DNS_ADDR"
fi

"$@"
if [ -n "$CONNECT" ]; then
	nmcli con up "$CONNECT"
fi
persist_file -r /etc/NetworkManager/system-connections
