#!/bin/sh -e
# SPDX-License-Identifier: MIT

CONF_DIR="/etc/atmark/abos_web/wireguard"
PUBLICKEY="publickey.txt"
PRIVATEKEY="privatekey.txt"

trap catch ERR

catch() {
	rm -f "$CONF_DIR/$PRIVATEKEY" "$CONF_DIR/$PUBLICKEY"
}

mkdir -p "$CONF_DIR"
umask 377
wg genkey | tee "$CONF_DIR/$PRIVATEKEY" | wg pubkey > "$CONF_DIR/$PUBLICKEY"
chmod 444 "$CONF_DIR/$PUBLICKEY"
persist_file -r "$CONF_DIR"
