#!/bin/sh -e
# SPDX-License-Identifier: MIT

CONF_DIR="/etc/atmark/abos_web/openvpn"
CONTAINER="abos_web_openvpn"
CONTAINER_CONF_FILE="/etc/atmark/containers/abos_web_openvpn.conf"
DNS_FILE="/etc/dnsmasq.d/openvpn_dns.conf"

if [ -e "$CONF_DIR/vpn_info.txt" ]; then
	if openvpn --version > /dev/null 2>&1; then
		CON_NAME=$(nmcli -t -f type,name c | awk -F: '$1 == "vpn" { print $2 }')
		if [ -n "$CON_NAME" ]; then
			CON_FILE="/etc/NetworkManager/system-connections/$CON_NAME.nmconnection"
			nmcli con del "$CON_NAME"
			persist_file -d "$CON_FILE" || :
		fi
		/usr/libexec/abos-web/nat_delete.sh tun0
	else
		podman stop "$CONTAINER" || :
		podman rm "$CONTAINER" || :
		persist_file -d "$CONTAINER_CONF_FILE" || :
		persist_file -d "$DNS_FILE" || :
		rc-service dnsmasq restart
	fi
	persist_file -dr "$CONF_DIR" || :
fi

WG_INFO_FILE="/etc/atmark/abos_web/wireguard/vpn_info.txt"
if [ -e "$WG_INFO_FILE" ]; then
	/usr/libexec/abos-web/wireguard_delete.sh
fi
