#!/bin/sh -e
# SPDX-License-Identifier: MIT

INTERFACE="$1"
PROTOCOL="$2"
DPORT="$3"
DESTINATION="$4"
DESTINATION_PORT="$5"

SYSCTL_CONF="/etc/sysctl.d/abos_web_ipforward.conf"

if iptables -t nat -D PREROUTING -i "$INTERFACE" -p "$PROTOCOL" -m "$PROTOCOL" --dport "$DPORT" \
	-m comment --comment "abos-web-pf" \
	-j DNAT --to-destination "$DESTINATION:$DESTINATION_PORT" >/dev/null 2>&1; then
	/etc/init.d/iptables save
	# prevent conflicts with container network settings
	sed -i -e '/NETAVARK/d' /etc/iptables/rules-save
	persist_file /etc/iptables/rules-save
fi

# remove ip_forward conf if no rule left
# we keep live setting because podman also needs it
if ! iptables -t nat -S | grep -q "abos-web"; then
	persist_file -d "$SYSCTL_CONF" || :
fi
