#!/bin/sh
# SPDX-License-Identifier: MIT

if [ "${PEER_DNS}" != "no" ]; then
	NS=
	DOMAIN=
	SEARCH=
	i=1
	while true ; do
		eval opt=\$foreign_option_${i}
		[ -z "${opt}" ] && break
		if [ "${opt}" != "${opt#dhcp-option DOMAIN *}" ] ; then
	    	if [ -z "${DOMAIN}" ] ; then
				DOMAIN="${opt#dhcp-option DOMAIN *}"
			else
				SEARCH="${SEARCH}${SEARCH:+ }${opt#dhcp-option DOMAIN *}"
			fi
		elif [ "${opt}" != "${opt#dhcp-option DNS *}" ] ; then
			NS="${NS}nameserver ${opt#dhcp-option DNS *}\n"
		fi
		i=$((${i} + 1))
	done

	if [ -n "${NS}" ] ; then
		DNS="# Generated by openvpn for interface ${dev}\n"
		if [ -n "${SEARCH}" ] ; then
			DNS="${DNS}search ${DOMAIN} ${SEARCH}\n"
		elif [ -n "${DOMAIN}" ]; then
			DNS="${DNS}domain ${DOMAIN}\n"
		fi
		DNS="${DNS}${NS}"
		printf "${DNS}" > /run/NetworkManager/openvpn_resolv.conf
		chmod 644 /run/NetworkManager/openvpn_resolv.conf
	fi
fi
