#!/bin/sh
# SPDX-License-Identifier: MIT

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

modify() {
	local id="$1"
	shift

	nmcli con modify "$id" "$@" || exit

	if nmcli -t -c no -f general.state con show "$id" | grep -qx "GENERAL.STATE:activated"; then
		nmcli con up "$id" || exit
	fi
	persist_file -r /etc/NetworkManager/system-connections
}

up() {
	local id="$1"

	nmcli con up "$id"
}

down() {
	local id="$1"

	nmcli con down "$id"
}

delete() {
	local id="$1"

	nmcli con delete "$id" || exit
	persist_file -r /etc/NetworkManager/system-connections
}

wifi_connect() {
	nmcli device wifi connect "$@" || exit
	persist_file -r /etc/NetworkManager/system-connections
}

mode="$1"
shift

case "$mode" in
delete|modify|up|down|wifi_connect)
	"$mode" "$@"
	;;
*)
	error "Usage: nmcli.sh [delete/up/down con|modify con options|wifi_connect options]"
	;;
esac
