#!/bin/sh -e
# SPDX-License-Identifier: MIT

ADDR_RANGE_START="$1"
ADDR_RANGE_END="$2"
LEASE_TIME="$3"
INTERFACE="$4"

CON_NAME="abos_web_dhcp_$INTERFACE"
DHCP_CONF="/etc/dnsmasq.d/$CON_NAME.conf"

trap catch ERR

catch() {
	if [ -e "$DHCP_CONF" ]; then
		persist_file -d "$DHCP_CONF"
		rc-service dnsmasq restart
	fi

	echo "Could not set up dhcp." >&2
}

cat > "$DHCP_CONF" <<EOF
interface=$INTERFACE
bind-dynamic
dhcp-range=tag:$INTERFACE, $ADDR_RANGE_START, $ADDR_RANGE_END, $LEASE_TIME
EOF

rc-service dnsmasq restart
persist_file "$DHCP_CONF"
