#!/bin/sh -e
# SPDX-License-Identifier: MIT

CUSTOMIZE_DIR="/etc/atmark/abos_web/customize"
COMMON_DIR="$CUSTOMIZE_DIR/static/common"
CSS_FILE="$COMMON_DIR/css/main.css"
COMMON_IMAGES_DIR="$COMMON_DIR/images"
LOGIN_IMAGES_DIR="$CUSTOMIZE_DIR/static/login/images"
STATIC_DIR="/usr/share/abos-web/static"

error() {
	printf "%s\n" "$@" >&2
	rm -rf "$TMP_DIR"
	exit 1
}

check_favicon() {
	fav_files="android-chrome-192x192.png
		android-chrome-512x512.png
		apple-touch-icon.png
		favicon-16x16.png
		favicon-32x32.png
		mstile-150x150.png"

	file_num=$(find "${FAVICON_ZIP%/*}/favicon" -type f | wc -l)
	if [ "$file_num" -ne "6" ]; then
		error "Invalid number of favicon files"
	fi
	for f in $fav_files; do
		ls "${FAVICON_ZIP%/*}/favicon/$f" > /dev/null 2>&1 || error "$f is not included in favicon"
	done
}

while [ $# -gt 0 ];
do
	case "$1" in
		"--tmp_dir")
			shift
			TMP_DIR="$1" ;;
		"--logo_login")
			shift
			LOGO_LOGIN_IMAGE="$1" ;;
		"--logo_header")
			shift
			LOGO_HEADER_IMAGE="$1" ;;
		"--color")
			shift
			COLOR_PATTERN="$1" ;;
		"--favicon")
			shift
			FAVICON_ZIP="$1" ;;
		*)
			;;
	esac
	shift
done

if ! [ -e "$CUSTOMIZE_DIR" ]; then
	mkdir "$CUSTOMIZE_DIR"
	cp -rf "$STATIC_DIR" "$CUSTOMIZE_DIR" > /dev/null 2>&1 || error "Could not copy customize directory"
fi

if [ -n "$COLOR_PATTERN" ]; then
	sed -i "s/\".*_color\.css\"/\"${COLOR_PATTERN}\.css\"/g" "$CSS_FILE"
fi

if [ -n "$LOGO_LOGIN_IMAGE" ]; then
	cp -f "$LOGO_LOGIN_IMAGE" "$LOGIN_IMAGES_DIR" > /dev/null 2>&1 || error "Could not copy ${LOGO_LOGIN_IMAGE##*/}"
	rm "$LOGO_LOGIN_IMAGE"
fi

if [ -n "$LOGO_HEADER_IMAGE" ]; then
	cp -f "$LOGO_HEADER_IMAGE" "$COMMON_IMAGES_DIR" > /dev/null 2>&1 || error "Could not copy ${LOGO_HEADER_IMAGE##*/}"
	rm "$LOGO_HEADER_IMAGE"
fi

if [ -n "$FAVICON_ZIP" ]; then
	unzip -o "$FAVICON_ZIP" -d "${FAVICON_ZIP%/*}" > /dev/null 2>&1 || error "Could not unzip ${FAVICON_ZIP##*/}"
	check_favicon
	cp -rf "${FAVICON_ZIP%/*}/favicon" "$COMMON_DIR"
	rm -r "$FAVICON_ZIP" "${FAVICON_ZIP%/*}/favicon"
fi

persist_file -r "$CUSTOMIZE_DIR"
