#!/bin/sh
# SPDX-License-Identifier: MIT

# Simple wrapper around npx playwright test.
# For more details see playwright/README.md

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

setup_playwright=1
while [ "$#" -gt 0 ]; do
	case "$1" in
	--skip-setup) setup_playwright="";;
	--) break;;
	-*) error "Unrecognized option $1";;
	*) break;;
	esac
	shift
done
[ "$#" = 2 ] || error "Usage: $0 <test_target> <password>"
export ABOSWEB_BASE="https://$1:58080"
export ABOSWEB_PASSWORD="$2"

command -v npm > /dev/null || error "npm must be installed to install playwright"
command -v npx > /dev/null || error "npx must be installed to run playwright"

cd "$(dirname "$0")"/playwright || exit

# remove previous test artifacts
rm -rf screenshots test-results

if [ -n "$setup_playwright" ]; then
	npm ci
	npx playwright install
fi

npx playwright test
