#!/bin/sh
# SPDX-License-Identifier: MIT

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

command -v curl >/dev/null || error "curl is required for this test"
command -v jq >/dev/null || error "jq is required for this test"

if [ "$#" = 2 ]; then
	ABOSWEB_BASE="https://$1:58080"
	ABOSWEB_PASSWORD="$2"
elif [ "$#" = 1 ] && [ -e "$1" ]; then
	. "$(realpath "$1")"
fi

[ -n "$ABOSWEB_BASE" ] && [ -n "$ABOSWEB_PASSWORD" ] \
	|| error "Usage: $0 <ip> <password>"


TESTDIR="$(realpath "$(dirname "$0")")/curl"
export TESTDIR ABOSWEB_BASE ABOSWEB_PASSWORD ABOSWEB_SSH_CONFIG

tmpdir="$(mktemp -d -t abos-web-tests-curl.XXXXXX)" || error "Could not create tmpdir"
# shellcheck disable=SC2064 ## want to expand now
trap "rm -rf '$tmpdir'" EXIT
cd "$tmpdir" || error "Could not enter tmpdir"

run-parts -v --regex '\.sh$' "$TESTDIR"
