// SPDX-License-Identifier: MIT

import { test, expect } from '@playwright/test';

test('top page', async ({ page }) => {
  await page.goto('/top');

  await expect(page).toHaveTitle(/トップページ/);

  // wait for nw stats to display before screenshot
  await page.waitForResponse('**/nwstatbar');

  // need a longer viewport to fit all the way down
  await page.setViewportSize({ width: 1280, height: 1100 });

  await page.screenshot({ path: 'screenshots/manual/top.png' });
});
