// SPDX-License-Identifier: MIT

import { test, expect } from '@playwright/test';
import { screenshot } from '../lib/screenshot.ts';

test('admin setting page test', async ({ page }) => {
  await page.goto('/settings');

  await expect(page).toHaveTitle(/設定管理/);

  // manual screenshot (must run first, assuming rest API ran before and prepared tokens)
  await test.step('Manual screenshot', async () => {
	await screenshot(page, {
		path: 'screenshots/manual/settings_restapi.png',
		locator: '#rest_tokens_view',
		margin: 5,
	});
  });

  await test.step('Create token', async () => {
	  // check there were no tokens with SwuInstall before
	  await expect(page.getByText('SwuInstall')).toHaveCount(0);

	  await page.getByRole('button', { name: 'トークンを追加' }).click();
	  await page.locator('#permissions').selectOption(['SwuInstall', 'Reboot']);
	  await page.getByRole('button', { name: '登録' }).click();

	  // check it's now listed
	  await expect(page.getByText('SwuInstall')).toHaveCount(1);
  });

  await test.step('Delete token', async () => {
	  await page.getByText('SwuInstall').click();
	  page.once('dialog', dialog => {
		  dialog.accept().catch(() => {});
	  });
	  await page.getByRole('button', { name: 'トークンを削除' }).click();

	  // check it's gone
	  await expect(page.getByText('SwuInstall')).toHaveCount(0);
  });
});

