// SPDX-License-Identifier: MIT

import { test, expect } from '@playwright/test';
import { login } from '../lib/login.ts';

test('login as a separate cookie and logout', async ({ browser }) => {
  var context = await browser.newContext({ storageState: undefined });
  var page = await context.newPage();

  await page.goto("/");
  await expect(page).toHaveTitle(/ログイン/);

  await test.step('login', async () => {
    await login(page);
  });

  await test.step('logout', async () => {
    await page.getByRole('link', { name: 'ログアウト' }).click();
    await expect(page).toHaveTitle(/ログイン/);
  });

  await page.goto("/");
  await expect(page).toHaveTitle(/ログイン/);
});
