// SPDX-License-Identifier: MIT

import { defineConfig, devices } from '@playwright/test';

/**
 * Read environment variables from file.
 * https://github.com/motdotla/dotenv
 */
// require('dotenv').config();

/**
 * See https://playwright.dev/docs/test-configuration.
 */
export default defineConfig({
  testDir: './.',
  /* Run tests in files in parallel */
  fullyParallel: true,
  /* Fail the build on CI if you accidentally left test.only in the source code. */
  forbidOnly: !!process.env.CI,
  retries: 0,
  workers: 3,
  maxFailures: 10,
  /* Reporter to use. See https://playwright.dev/docs/test-reporters */
  reporter: 'line',
  /* Shared settings for all the projects below. See https://playwright.dev/docs/api/class-testoptions. */
  use: {
    /* Base URL to use in actions like `await page.goto('/')`. */
    baseURL: process.env.ABOSWEB_BASE,
    ignoreHTTPSErrors: true,

    /* Collect trace when retrying the failed test. See https://playwright.dev/docs/trace-viewer */
    trace: 'on-first-retry',
  },

  /* Configure projects for major browsers */
  projects: [
    {
      name: 'setup',
      testMatch: /.*\.setup\.ts/,
      use: {
	viewport: { width: 1280, height: 720 },
      }
    },
    {
      name: 'tests',
      testDir: './tests',
      dependencies: ['setup'],
      use: {
	/* Run on chromium by default, but can be overriden with PLAYWRIGHT_BROWSER
	* e.g. 'Desktop Firefox' or 'Pixel 5'. Note if devices wasn't found playwright
	* silently falls back to chromium. */
        ...devices[process.env.PLAYWRIGHT_BROWSER || 'Desktop Chrome'],
	storageState: '.auth/login.json',
      },
    },
    {
      name: 'tests-serialized',
      testDir: './tests-serialized',
      workers: 1,
      dependencies: ['tests'],
      use: {
	...devices[process.env.PLAYWRIGHT_BROWSER || 'Desktop Chrome'],
	storageState: '.auth/login.json',
      },
    },
  ],
});
