#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

# prepare tokens for manual -- must be last as it kills '$token'
prepare_tokens() {
	# Create tokens as per manual
	req_bearer '/api/tokens/35ac39a8-1eeb-4bb2-84d2-cb542cdbc873' \
		-X POST -d permissions=Admin
	req_bearer '/api/tokens/5c426ce5-8fcb-4e54-9ff6-80aba50935ee' \
		-X POST -d permissions=Reboot -d permissions=NetworkView

	# Delete last token and check
	# (Note we trust 00_create to have deleted all other tokens, and
	# no other tokens were left behind)
	req_bearer "/api/tokens/$(cat token)" -X DELETE

	# Record manual token for next tests that shouldn't exist...
	echo "35ac39a8-1eeb-4bb2-84d2-cb542cdbc873" > token

	req_bearer '/api/tokens'
	[ "$(jq -c '.tokens | sort_by(.token)' < req)" \
	    = '[{"token":"35ac39a8-1eeb-4bb2-84d2-cb542cdbc873","permissions":["Admin"]},{"token":"5c426ce5-8fcb-4e54-9ff6-80aba50935ee","permissions":["Reboot","NetworkView"]}]' ] \
	       || error "Tokens not as expected for manual"
}

run_tests prepare_tokens
