#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

setup_openvpn_cert() {
	req_bearer "/api/vpn/openvpn" -F setting_name=dummy_vpn_cert \
		-F conf=@"$TESTDIR/data/vpn/dummy_ovpn.ovpn" \
		-F cert=@"$TESTDIR/data/vpn/dummy_ovpn.cert" \
		-F cert=@"$TESTDIR/data/vpn/dummy_ovpn.key" \
		-F auth_type=cert -F key_pass=dummy \
		|| error "Could not setup openvpn by cert"
	req_bearer "/api/containers" \
		|| error "Could not list containers"
	check_req_jq setup_openvpn_cert \
		'.containers[] | .name | select( . | test("abos_web_openvpn"))' abos_web_openvpn
}

setup_openvpn_userpass() {
	req_bearer "/api/vpn/openvpn" -F setting_name=dummy_vpn_userpass \
		-F conf=@"$TESTDIR/data/vpn/dummy_ovpn.ovpn" \
		-F username=dummy_user -F password=dummy_password \
		-F auth_type=userpass \
		|| error "Could not setup openvpn by userpass"
	req_bearer "/api/containers" \
		|| error "Could not list containers"
	check_req_jq setup_openvpn_userpass \
		'.containers[] | .name | select( . | test("abos_web_openvpn"))' abos_web_openvpn
}

setup_openvpn_delete() {
	req_bearer "/api/vpn/openvpn" -X DELETE \
		|| error "Could not delete openvpn"
	req_bearer "/api/containers" \
		|| error "Could not list containers"
	check_req_jq setup_openvpn_delete \
		'.containers[] | .name | select( . | test("abos_web_openvpn"))' ""
}


run_tests setup_openvpn_cert setup_openvpn_userpass || exit
run_tests setup_openvpn_delete || exit
