#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

[ -n "$ABOSWEB_PASSWORD" ] || error "ABOSWEB_PASSWORD must be set"

set_password() {
	req_bearer "/api/password" -X POST -d password=abc123 -d hashed=false \
		|| error "Could not set password"
	# try to list tokens to check password
	req "/api/tokens" -u any:abc123 \
		|| error "Password wasn't set correctly"
	# also check bad password is refused...
	if req "/api/tokens" -u any:badpass; then
		error "Could list tokens with a bad password!"
	fi
}

set_password_hashed() {
	# 'otherpass' in sha512crypt
	# shellcheck disable=SC2016 # yes, don't expand these $...
	local pw='$6$s9nb4BtC0K0sEzjl$4qiHEBXpO1OThXjKrTExwq7830/BEzcaxLzdE17RAXrPqbgfL9Z4o/jeMMvtpmOEIW/8EdtxFApvcuQaZtR2r0'
	req_bearer "/api/password" -X POST -d "password=$pw" -d hashed=true \
		|| error "Could not set password hashed"
	req "/api/tokens" -u any:otherpass \
		|| error "Encrypted password wasn't set correctly"
}

check_nopass() {
	local redir
	redir=$(req "" -w "%{redirect_url}\n") \
		|| error "Could not get /?"
	[ -z "$redir" ] \
		|| error "Redirect on home page was set with valid password?"

	# '!' as hash is initial 'no password' state
	req_bearer "/api/password" -X POST -d "password=!" \
		|| error "Could not reset password empty"

	# home page redirects to new password form
	redir=$(req "" -w "%{redirect_url}\n") \
		|| error "Could not get / with no password set"
	[ "${redir##*/}" = "new_password" ] \
		|| error "Didn't get redirected to new_password with no password set"

	# login with any password should be allowed
	req "/api/tokens" -u any:whatever \
		|| error "Could not login with any password when none was set"
}

restore_password() {
	req_bearer "/api/password" -X POST -d hashed=false \
			--data-urlencode "password=$ABOSWEB_PASSWORD" \
		|| error "Could not reset original password"
}

run_tests set_password set_password_hashed check_nopass restore_password
