#!/bin/sh
# SPDX-License-Identifier: MIT

. "$(dirname "$0")/common"

nat() {
	req_bearer '/api/nat'
	# reset any previous failed test
	if [ "$(cat req)" != '[]' ]; then
		jq -r '.[] | .interface' < req \
			| while read -r interface; do
				req_bearer "/api/nat/$interface" -X DELETE
			done
		req_bearer '/api/nat'
	fi
	check_req empty '[]'

	req_bearer '/api/nat/eth0' -X POST
	req_bearer '/api/nat'
	check_req eth0 '[{"interface":"eth0"}]'

	# can repeat
	req_bearer '/api/nat/eth0' -X POST
	req_bearer '/api/nat'
	check_req eth0_again '[{"interface":"eth0"}]'

	req_bearer '/api/nat/eth0' -X DELETE
	req_bearer '/api/nat'
	check_req empty_again '[]'

	# delete again does not error
	req_bearer '/api/nat/eth0' -X DELETE
	req_bearer '/api/nat'
	check_req empty_again2 '[]'
}

pf() {
	req_bearer '/api/port_forwarding'
	# reset any previous data
	if [ "$(cat req)" != '[]' ]; then
		jq -c -r '.[]' < req \
			| while read -r pf; do
				req_bearer '/api/port_forwarding' -X DELETE \
					-H 'Content-type: application/json' \
					-d "$pf"
			done
		req_bearer '/api/port_forwarding'
	fi
	check_req empty '[]'


	req_bearer '/api/port_forwarding' -X POST \
		-d interface=eth0 -d dport=444 \
		-d destination=127.0.0.1 -d destination_port=555
	req_bearer '/api/port_forwarding'
	check_req_jq add1 length 1
	check_req_jq add1 .[0].interface eth0
	check_req_jq add1 .[0].protocol tcp
	check_req_jq add1 .[0].dport 444
	check_req_jq add1 .[0].destination 127.0.0.1
	check_req_jq add1 .[0].destination_port 555

	# can repeat
	req_bearer '/api/port_forwarding' -X POST \
		-d interface=eth0 -d dport=444 \
		-d destination=127.0.0.1 -d destination_port=555
	req_bearer '/api/port_forwarding'
	check_req_jq add2 length 1

	# udp
	req_bearer '/api/port_forwarding' -X POST \
		-d interface=eth0 -d protocol=udp -d dport=444 \
		-d destination=127.0.0.1 -d destination_port=555
	req_bearer '/api/port_forwarding'
	check_req_jq add2 length 2
	check_req_jq add2 '[.[].protocol]| sort[]' "tcp
udp"

	# delete
	req_bearer '/api/port_forwarding' -X DELETE \
		-d interface=eth0 -d protocol=udp -d dport=444 \
		-d destination=127.0.0.1 -d destination_port=555
	req_bearer '/api/port_forwarding' -X DELETE \
		-d interface=eth0 -d dport=444 \
		-d destination=127.0.0.1 -d destination_port=555
	req_bearer '/api/port_forwarding'
	check_req empty_again '[]'

	# delete again does not error
	req_bearer '/api/port_forwarding' -X DELETE \
		-d interface=eth0 -d dport=444 \
		-d destination=127.0.0.1 -d destination_port=555
	req_bearer '/api/port_forwarding'
	check_req empty_again2 '[]'
}

run_tests nat pf
