// SPDX-License-Identifier: MIT

authTypeSelect();
connectionTypeSelect();

function authTypeSelect() {
    const authType = document.getElementById("auth_type");
    const userpass = document.getElementById("userpass");
    const certkey = document.getElementById("certkey");
    const user = document.getElementById("username");
    const pass = document.getElementById("password");

    if (authType) {
        if (authType.value == "userpass") {
            userpass.style.display = "block";
            certkey.style.display = "none";
            user.setAttribute("required", "");
            pass.setAttribute("required", "");
        } else {
            userpass.style.display = "none";
            certkey.style.display = "block";
            user.removeAttribute("required");
            pass.removeAttribute("required");
        }
    }
}

function connectionTypeSelect() {
    const connectionType = document.getElementById("connection_type");
    const openvpn = document.getElementById("openvpn");
    const wireguard = document.getElementById("wireguard");

    if (connectionType) {
        if (connectionType.value == "openvpn") {
            openvpn.style.display = "block";
            if (wireguard) {
                wireguard.style.display = "none";
            }
        } else if (connectionType.value == "wireguard") {
            openvpn.style.display = "none";
            if (wireguard) {
                wireguard.style.display = "block";
            }
        }
    }
}

function close_vpn_popup() {
    document.getElementById("vpn_progress_overlay").style.visibility = "hidden";
    window.location.reload();
}

function vpn_ws_on_message(ev) {
    var box = document.getElementById("vpn_progress_text");
    if (ev.target.x_first) {
        box.innerHTML = ""
        ev.target.x_first = false;
    }
    var lines = ev.data.split('\n');
    for (var i = 0; i < lines.length; i++) {
        var p = document.createElement("p");
        p.innerText = lines[i];
        box.appendChild(p);
        if (lines[i].includes("Initialization Sequence Completed")) {
            var done = document.createElement("p");
            done.innerHTML = '<b>接続が成功しました。</b>';
            box.appendChild(done);
            ev.target.close();
        }
    }
}

function vpn_setup(form) {
    document.getElementById("vpn_progress_text").innerHTML = "";
    const formData = new FormData(form);
    var xhr = new XMLHttpRequest();
    xhr.addEventListener('progress', vpn_progress);

    xhr.open(form.method, form.action, true);
    xhr.send(formData);
}

function vpn_start_setup(ev) {
    ev = ev || window.event;

    // abort normal post to avoid page reloading
    ev.preventDefault();

    if (!window.confirm('起動中のコンテナを全て停止する必要があります。停止したコンテナはVPN接続後自動的に起動します。よろしいですか？')) {
        return false;
    }

    // open popup
    document.getElementById("vpn_progress_overlay").style.visibility = "visible";

    var ws = new WebSocket(location.origin.replace(/^http/, 'ws') + "/vpn_ws");
    ws.x_first = true;
    ws.onopen = function(_ev) {
        vpn_setup(ev.target);
    }
    ws.onmessage = vpn_ws_on_message;

    return false;
}

function wg_gen_key() {
    var wg_self_publickey = document.getElementById("self_publickey");

    fetch(location.origin + "/vpn_wg_gen_key")
      .then(response => response.text())
      .then(publickey => {
        wg_self_publickey.innerText = publickey;
      })
      .catch(err => {
        wg_self_publickey.innerText = "公開鍵を取得できませんでした。";
      });

    return false;

}

document.addEventListener("DOMContentLoaded", function(_ev) {
    var elements = document.getElementsByClassName("vpn_post");
    for (var i = 0; i < elements.length; i++) {
        elements[i].addEventListener('submit', vpn_start_setup);
    }
    document.getElementById("vpn_progress_close").addEventListener("click", close_vpn_popup);
})
