// SPDX-License-Identifier: MIT

use axum::{response::IntoResponse, routing::post, Router};

use crate::common::{
    json_stream_command, CheckAuthRestApi, CommandOpts, RestApiPermissionResetDefault,
};

pub fn routes() -> Router {
    Router::new().route("/api/reset_default", post(restapi_reset_default))
}

/// POST "/api/reset_default"
/// - Access: ResetDefault
/// - Input: None
/// - Output: json stream of object with 'line' items, followed by
///   either exit_code or exit_signal
async fn restapi_reset_default(
    _auth: CheckAuthRestApi<RestApiPermissionResetDefault>,
) -> impl IntoResponse {
    json_stream_command(
        vec!["reset_default.sh".to_string()],
        &CommandOpts {
            // This should not stop halfway
            stream_ignore_output_errors: true,
            ..Default::default()
        },
        None,
    )
}
