// SPDX-License-Identifier: MIT

use axum::{
    extract::Request,
    middleware::Next,
    response::{IntoResponse, Redirect, Response},
};

use crate::common::Config;

#[derive(Clone)]
pub struct Title(pub String);

pub async fn get_title(mut request: Request, next: Next, url: &str) -> Response {
    if let Some(title) = Config::get().customize.get().get_page_title(url) {
        request.extensions_mut().insert(Title(title));
    } else {
        return Redirect::temporary("/top").into_response();
    }
    next.run(request).await
}
