// SPDX-License-Identifier: MIT

use tokio::fs;

use crate::common;

#[cfg(debug_assertions)]
const MANAGE_ROOT_PATH: &str = "manage_root";
#[cfg(not(debug_assertions))]
const MANAGE_ROOT_PATH: &str = "/etc/atmark/abos_web/manage_root";

#[derive(Clone, Debug)]
pub struct SoftwareConfig {
    pub is_wg_installed: bool,
    pub manage_root: bool,
    pub is_ovpn_installed: bool,
}

impl SoftwareConfig {
    pub async fn load() -> Self {
        SoftwareConfig {
            is_wg_installed: is_wg_installed().await,
            manage_root: manage_root().await,
            is_ovpn_installed: is_ovpn_installed().await,
        }
    }
}

async fn is_wg_installed() -> bool {
    common::exec_command_no_script(&["wg", "--help"])
        .await
        .is_ok()
}

async fn manage_root() -> bool {
    fs::try_exists(MANAGE_ROOT_PATH).await.unwrap_or(false)
}

async fn is_ovpn_installed() -> bool {
    common::exec_command_no_script(&["openvpn", "--version"])
        .await
        .is_ok()
}
