#!/bin/sh -e
# SPDX-License-Identifier: MIT

is_a6e_catm1() {
	overlays="$(awk -F= '$1 == "fdt_overlays" { print $2 }' /boot/overlays.txt 2>/dev/null)"
	case " $overlays " in
	*" armadillo-iotg-a6e-ems31.dtbo "*)
		return 0;;
	*)
		return 1;;
	esac
}

is_number() {
	if [ -z "$1" ]; then
		return 1
	fi

	case ${1:-} in
		'' | *[!0-9]* ) return 1
	esac
	return 0
}

type mm-modem-num > /dev/null 2>&1 || exit

# It is not cyclic update, that a signal quality on the A6E Cat.M1.
# use AT+CSQ.
if is_a6e_catm1; then
	csq=$(send-at /dev/ttyMux2 AT+CSQ echo ems31 2>&1 > /dev/null \
		| awk -F '[, ]' '/^\+CSQ:/ { print $2 }')
	is_number "$csq" || exit
	if [ "$csq" -lt 0 ] || [ "$csq" -eq 99 ] || [ "$csq" -eq 255 ];then
		csq=0
	elif [ "$csq" -gt 31 ];then
		csq=31
	fi
	printf "%d" "$((csq*100/31))"
else
	printf "%s" "$(mmcli -m "$(mm-modem-num)" -K 2>/dev/null | awk '$1 == "modem.generic.signal-quality.value" { print $3 }')"
fi
