#!/bin/sh -e
# SPDX-License-Identifier: MIT

CON_NAME=$(nmcli -t -f type,name c | awk -F: '$1 == "wireguard" { print $2 }')
[ -n "$CON_NAME" ] || CON_NAME="wg"
CON_FILE="/etc/NetworkManager/system-connections/$CON_NAME.nmconnection"
CONF_DIR="/etc/atmark/abos_web/wireguard"

if nmcli con show "$CON_NAME" >/dev/null 2>&1; then
	nmcli con del "$CON_NAME"
	persist_file -d "$CON_FILE" || :
fi

if [ -e "$CONF_DIR" ]; then
    persist_file -dr "$CONF_DIR" || :
fi

/usr/libexec/abos-web/nat_delete.sh wg
