#!/bin/sh
# SPDX-License-Identifier: MIT

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

set_timezone() {
	local timezone="$1"
	[ -e "/usr/share/zoneinfo/$timezone" ] \
		|| error "$timezone is not installed"
	ln -sf "/usr/share/zoneinfo/$timezone" /etc/localtime \
		|| error "Could not overwrite /etc/localtime"
	persist_file /etc/localtime || error "Could not persist /etc/localtime"
}

sync_time() {
	local time="$1"
	case "$time" in
	*[!0-9]*) error "$time does not look like an unix timestamp";;
	esac

	date -s "@$time" \
		|| error "Could not set time to $time"
	hwclock -u --systohc \
		|| error "Could not sync time to RTC"
}

case "$1" in
timezone)
	[ $# = 2 ] || error "timezone not given or too many arguments"
	set_timezone "$2"
	;;
sync)
	[ $# = 2 ] || error "time to sync not given or too many arguments"
	sync_time "$2"
	;;
*)
	error "Unknown option $1"
	;;
esac
