#!/bin/sh

if [ ! -e /etc/atmark/abos_web/manage_root ]; then
	echo "Not allowed" >&2
	exit 1
fi


# helpers
modified_files=""
track() {
	modified_files="$modified_files $*"
}

service_action=""
service() {
	# stop > restart > start
	case "$service_action","$1" in
	stop,*|*,stop) service_action=stop;;
	*,restart|restart,*) service_action=restart;;
	*start*) service_action=start;;
	esac
}

fail() {
	# shellcheck disable=SC2086 ## split glob
	[ -n "$modified_files" ] && persist_file -R $modified_files
	exit 1
}

# main functions
sshd_enable() {
	track /etc/ssh/ssh_host_* /etc/runlevels/default/sshd
	ssh-keygen -A || fail
	rc-update add sshd || fail
	service start
}

sshd_disable() {
	track /etc/runlevels/default/sshd
	rc-update del sshd || fail
	service stop
}

rootpw_enable() {
	track /etc/ssh/sshd_config.d/50_abos_web.conf
	cat > /etc/ssh/sshd_config.d/50_abos_web.conf <<EOF || fail
PermitRootLogin yes
EOF
	service restart
}

rootpw_disable() {
	track /etc/ssh/sshd_config.d/50_abos_web.conf
	rm -f /etc/ssh/sshd_config.d/50_abos_web.conf || fail
	service restart
}

sshd_pubkey() {
	# read from stdin
	track /root/.ssh/authorized_keys
	cat > /root/.ssh/authorized_keys || fail
}


while [ $# -gt 0 ];
do
	case "$1" in
	sshd_enable|sshd_disable|\
	rootpw_disable|rootpw_enable|\
	sshd_pubkey)
		"$1"
		;;
	*)
		echo "Unknown command $1"
		fail
		;;
	esac
	shift
done

if [ -n "$service_action" ]; then
	rc-service sshd "$service_action" || fail
fi
# shellcheck disable=SC2086 ## split on purpose
[ -n "$modified_files" ] && persist_file $modified_files
