#!/bin/sh
# SPDX-License-Identifier: MIT

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

mode="$1"

case "$mode" in
reboot|poweroff)
	"$mode"
	;;
sleep)
	if command -v aiot-sleep >/dev/null; then
		aiot-sleep
	else
		echo mem > /sys/power/state
	fi
	;;
*)
	error "Usage: power.sh [reboot|poweroff|sleep]"
	;;
esac
