#!/bin/sh -e
# SPDX-License-Identifier: MIT

OUT_INTERFACE="$1"

SYSCTL_CONF="/etc/sysctl.d/abos_web_ipforward.conf"

trap catch ERR

catch() {
	set +e
	if iptables -t nat -D POSTROUTING -o "$OUT_INTERFACE" -m comment --comment "abos-web-nat" -j MASQUERADE >/dev/null 2>&1; then
		/etc/init.d/iptables save
		sed -i -e '/NETAVARK/d' /etc/iptables/rules-save
		persist_file /etc/iptables/rules-save
	fi

	echo "Could not set up nat." >&2
}

if ! [ -e "$SYSCTL_CONF" ]; then
	sysctl net.ipv4.ip_forward=1
	echo "net.ipv4.ip_forward = 1" > "$SYSCTL_CONF"
	persist_file "$SYSCTL_CONF"
fi

# rule already present
if iptables -t nat -C POSTROUTING -m comment --comment "abos-web-nat" -o "$OUT_INTERFACE" -j MASQUERADE; then
	exit
fi

iptables -t nat -A POSTROUTING -m comment --comment "abos-web-nat" -o "$OUT_INTERFACE" -j MASQUERADE
/etc/init.d/iptables save
# prevent conflicts with container network settings
sed -i -e '/NETAVARK/d' /etc/iptables/rules-save
rc-update add iptables
persist_file /etc/iptables/rules-save /etc/runlevels/default/iptables
