#!/bin/sh
# SPDX-License-Identifier: MIT

print_info() {
	local iface="$1" info
	local conf="/etc/dnsmasq.d/abos_web_dhcp_$iface.conf"

	[ -e "$conf" ] || return 0

	info="$iface,$(/sbin/ip -o -4 addr list "$iface" 2> /dev/null | awk '{print $4}')"
	info="$info,$(awk -v tag="dhcp-range=tag:$iface," '$1 == tag { print $2 $3 $4 }' "$conf")"

	# iface,bridge_addr/netmask,start_addr,end_addr,lease_time
	printf "%s\n" "$info"
}

if [ -n "$1" ]; then
	print_info "$1"
	exit
fi

for file in /etc/dnsmasq.d/abos_web_dhcp_*.conf; do
	iface=${file#*/abos_web_dhcp_}
	iface=${iface%.conf}
	print_info "$iface"
done
