#!/bin/sh -e
# SPDX-License-Identifier: MIT

ARCHIVE_NAME="$1"

# shellcheck disable=SC2016 ## variables are quoted properly
unshare -m sh -ec '
	mount -t tmpfs tmpfs /mnt
	mkdir -p "/mnt/$1/log" "/mnt/$1/at-log" "/mnt/$1/container-log"
	mount --bind /var/log "/mnt/$1/log"
	if [ -d /var/at-log ]; then
		mount --bind /var/at-log "/mnt/$1/at-log"
	fi
	for container_name in $(podman ps -a --format "{{.Names}}"); do
		log_path="$(podman inspect "$container_name" --format={{.HostConfig.LogConfig.Path}})"
		[ -e "$log_path" ] || continue
		touch "/mnt/$1/container-log/${container_name}.log"
		mount --bind "$log_path"  "/mnt/$1/container-log/${container_name}.log"
	done
	tar --exclude="$1/log/armadillo-twin-agent/*.pem" -C /mnt -cz "$1"' -- "$ARCHIVE_NAME"
