# ABOS Web

## 🛠️ 環境セットアップ＆確認

```bash
# Rust 関連をインストール（https://www.rust-lang.org/ja/tools/install）
curl --proto '=https' --tlsv1.2 -sSf https://sh.rustup.rs | sh
rustup update stable

# 開発用ツール
cargo install cross cargo-watch cargo-audit

# リポジトリクローン & 実行
git clone <repository-url> && cd abos-web
./utils/install_commit_hook.sh  # Git pre-commitフック有効化

# 開発時用のサーバー起動（ソースコード変更時に自動リロード）
cargo watch -x 'run --features tls-rustls -- -v'
# https://localhost:58080 または localhost:58080 でアクセス可能
# VS Codeを使用している場合は、下部の「ポート」タブにアドレスが表示される
```

### VS Code 開発環境
推奨拡張機能:
```bash
# rust-analyzer （Rust言語サーバー）
code --install-extension rust-lang.rust-analyzer

# CodeLLDB （デバッガー）
code --install-extension vadimcn.vscode-lldb

# Dependi （依存関係管理）
code --install-extension fill-labs.dependi
```


### クロスコンパイル・Armadillo実機デプロイ

```bash
# Armadillo の sshd を有効化する
armadillo:~# rc-update add sshd
armadillo:~# persist_file /etc/runlevels/default/sshd
armadillo:~# reboot

# SSH の公開鍵を Armadillo の root に登録する
PC:~# ssh-keygen -t ed25519 # すでに生成されている場合は不要
PC:~# cat ~/.ssh/id_ed25519.pub
armadillo:~# mkdir .ssh
armadillo:~# echo "↑の実行結果" >> .ssh/authorized_keys
armadillo:~# persist_file .ssh/authorized_keys

# Armadilloへ自動デプロイ
./utils/update_armadillo.sh root@[ArmadilloのIPアドレス]
# → クロスコンパイル環境用意 + クロスコンパイル + SSH転送 + サービス再起動
# Starting abos-web ... [ ok ] と表示されれば成功
```

ただビルドする場合

```bash
# ARM32向けビルド
cross build --release --target armv7-unknown-linux-musleabi --features tls-rustls

# ARM64向けビルド
cross build --release --target aarch64-unknown-linux-musl --features tls-rustls
```


## 🎯 機能セット

ABOS Webはデバイスに応じて異なる機能セット（Variant set）を用意しており、
この機能セットからメニューの構成・UI要素などが ABOS Web 起動時に決定されます。

### 利用可能な機能セット

- **`standard`** - ボードやIoTゲートウェイ用の標準機能セット（デフォルト）
- **`router`** - IoTルーター用の機能セット
  - USB制御機能などを除外

### 機能セットの切り替え

```bash
# 環境変数での指定（PC）
export ABOSWEB_VARIANT="router"
cargo run --features tls-rustls -- -v

# 設定ファイルでの指定（Armadillo）
echo 'ABOSWEB_VARIANT="router"' >> /etc/conf.d/abos-web

# デプロイ時の設定ファイルでの指定（PC -> Armadillo）
./utils/update_armadillo.sh root@[ArmadilloのIPアドレス] variant-set router
```

機能セットは `/usr/share/abos-web/variant/{ABOSWEB_VARIANT}.json` から読み込まれます。


## TLSについて
APKBUILD時には openssl-dev が依存先であるため、TLS実装としてOpenSSLを選択できますが、
クロスコンパイル時にはターゲット（aarch64-unknown-linux-muslなど）に openssl-dev が含まれていないため、
代わりのTLS実装として RustTLS を選択してください（`--features tls-rustls`）。


## 🧪 テスト & コード品質

### cargo のチェック
```bash
cargo clippy                          # 静的解析
cargo clippy --fix                    # 静的解析 & 自動修正
cargo fmt                             # フォーマット
cargo audit                           # 脆弱性チェック
```
