// SPDX-License-Identifier: MIT
#pragma once

#include <stdbool.h>
#include <linux/types.h>

struct emmc_state {
	int verbose;
	// selfrefresh
	bool use_system_time;
};

typedef int (*tune_fn)(const char *dev, struct emmc_state *state);

/* selfrefresh.c */
int emmc_selfrefresh(const char *dev, struct emmc_state *state);

/* setup.c */
int emmc_setup(const char *dev, struct emmc_state *state);

/* helpers.c */
int read_extcsd(int fd, __u8 *ext_csd);
int write_extcsd_value(int fd, __u8 index, __u8 value, unsigned int timeout_ms);
bool mmc_is_micron(const char *dev, int verbose);
