// SPDX-License-Identifier: MIT
#pragma once

#include <errno.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

// mains
int fsfreeze_main(int argc, char *argv[]);
int mkbootscr_main(int argc, char *argv[]);
int renameat2_main(int argc, char *argv[]);
int schedule_ts_main(int argc, char *argv[]);
int emmc_sref_main(int argc, char *argv[]);

// utils
#define xassert(expr)                                                     \
	({                                                                \
		if (!(expr)) {                                            \
			fprintf(stderr, "Assertion failed: %s\n", #expr); \
			return -1;                                        \
		}                                                         \
	})
#define xmalloc(size)                                \
	({                                           \
		void *ret = malloc(size);            \
		if (!ret) {                          \
			perror("allocation failed"); \
			return -ENOMEM;              \
		}                                    \
		ret;                                 \
	})
#define xstrdup(str)                                 \
	({                                           \
		void *ret = strdup(str);             \
		if (!ret) {                          \
			perror("allocation failed"); \
			return -ENOMEM;              \
		}                                    \
		ret;                                 \
	})
#define xopen(path, args...)                                             \
	({                                                               \
		int ret = open(path, args);                              \
		if (ret < 0) {                                           \
			ret = -errno;                                    \
			fprintf(stderr, "open '%s' failed: %m\n", path); \
			return ret;                                      \
		}                                                        \
		ret;                                                     \
	})
#define xfprintf(args...)                \
	({                               \
		int ret = fprintf(args); \
		if (ret < 0)             \
			return -errno;   \
		ret;                     \
	})

#define _cleanup_(f) __attribute__((cleanup(f)))

static inline void *steal_pointer(void *ptr)
{
	void *val = *(void **)ptr;
	*(void **)ptr = NULL;
	return val;
}

static inline void freep(void *ptr)
{
	free(*(void **)ptr);
}

static inline void closep(int *fd)
{
	if (*fd < 3)
		return;
	close(*fd);
	*fd = -1;
}

static inline void unlinkp(char **path)
{
	if (!*path)
		return;
	if (*path[0])
		unlink(*path);
	free(*path);
}
