#!/bin/bash

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

skip() {
	printf "%s\n" "$@"
	exit 0
}

[[ -e /etc/atmark-release ]] || skip "abos-ctrl podman-rw only makes sense on ABOS"

cd "$(dirname "$0")" || error "cd test dir"


# when running as user with 'vfs' driver podman fails due
# to lack fo additionalimagestore support. abos uses overlay,
# so test that
export STORAGE_DRIVER=overlay

# prepare and clean test dir.
TESTDIR=$(mktemp -d /tmp/abos-base.podman_rw.XXXXXX) \
	|| error "Could not create temp dir"
trap 'rm -rf "$TESTDIR"' EXIT

echo "FROM scratch" \
	| ../tools/abos-ctrl podman-rw --root "$TESTDIR" \
		build \
		-t testimage:latest \
		-f - \
	|| error "build failed"
LIST="$(../tools/abos-ctrl podman-rw --root "$TESTDIR" \
		image list --format "{{.Names}}")" \
	|| error "Could not list images (testimage)"
[ "$LIST" = "[localhost/testimage:latest]" ] \
	|| error "list content was not as expected. Should contain exactly testimage, got: $LIST"
../tools/abos-ctrl podman-rw --root "$TESTDIR" \
		rmi testimage \
	|| error "Could not remove image"
LIST="$(../tools/abos-ctrl podman-rw --root "$TESTDIR" \
		image list --format "{{.Names}}")" \
	|| error "Could not list images (empty)"
[ "$LIST" = "" ] \
	|| error "list content was not as expected. Should be empty, got: $LIST"


