#!/bin/sh

# tests for persist_file that must be run on ABOS until
# persist_file is made more flexible (rootless? /live/rootfs path?)

PERSIST_FILE="${PERSIST_FILE:-persist_file}"


error() {
	printf "ERROR: %s\n" "$@" >&2
	exit 1
}

if ! command -v "$PERSIST_FILE" > /dev/null; then
	error "${PERSIST_FILE} not runnable/found"
fi

set -e

# relative with & without prefix, absolute
for prefix in "" "./" "/root/persist_file_tests/"; do
	cd
	persist_file -rd /root/persist_file_tests || true
	mkdir -p /root/persist_file_tests
	cd /root/persist_file_tests

	# note: d must have trailing /
	for d in "" d.single/ d.double/d.subdir/ d.triple/d.subdir1/d.subdir2/ \
			d.triple/d.subdir1/../d.subdir3/ \
			d.triple/d.subdir1/../../d.single2/ \
			d.triple/../; do
		[ -n "$d" ] && mkdir -p "$d"
		pd="$prefix$d"

		echo foo > "$d"file
		persist_file -v "$prefix$d"file
		[ "$(cat "/live/rootfs/root/persist_file_tests/$d"file)" = foo ] \
			|| error "file not persisted ($pd)"
		persist_file -dv "$prefix$d"file
		[ -e "/live/rootfs/root/persist_file_tests/$d"file ] \
			&& error "file not deleted ($pd, rootfs)"
		[ -e "$d"file ] \
			&& error "file not deleted ($pd, overlay)"

		# skip ""
		[ -n "$pd" ] || continue
		echo foo > "$d"file
		persist_file -rv "$pd"
		[ "$(cat "/live/rootfs/root/persist_file_tests/$d"file)" = foo ] \
			|| error "file not persisted ($pd, dir)"

		echo bar > "$d"file
		persist_file -rv "${pd%/}"
		[ "$(cat "/live/rootfs/root/persist_file_tests/$d"file)" = bar ] \
			|| error "file not persisted ($pd, dir update)"

		# don't delete .
		[ "$(realpath "$pd")" = /root/persist_file_tests ] && continue
		persist_file -rvd "$pd"
		[ -e "/live/rootfs/root/persist_file_tests/$d"file ] \
			&& error "file not deleted ($pd, dir, rootfs)"
		[ -e "$d"file ] \
			&& error "file not deleted ($pd, dir, overlay)"

		mkdir -p "$d"
		echo foo > "$d"file
		persist_file -rv "${pd%/}"
		[ "$(cat "/live/rootfs/root/persist_file_tests/$d"file)" = foo ] \
			|| error "file not persisted ($pd, dir again)"
		rm -rf "$d"
		persist_file -rvd "$pd"file
		[ -e "/live/rootfs/root/persist_file_tests/$d"file ] \
			&& error "file not deleted ($pd, dir, rootfs after rm)"

		mkdir -p "$d"
		echo foo > "$d"file
		persist_file -rv "$pd"file
		[ "$(cat "/live/rootfs/root/persist_file_tests/$d"file)" = foo ] \
			|| error "file not persisted ($pd, file again)"
		rm -rf "$d"
		persist_file -rvd "$pd"
		[ -e "/live/rootfs/root/persist_file_tests/$d"file ] \
			&& error "file not deleted ($pd, rootfs after rm)"
	done

	# symlinks
	ln -s deadlink dead
	persist_file -v "$prefix"dead
	[ "$(readlink /live/rootfs/root/persist_file_tests/dead)" = deadlink ] \
		|| error "deadlink"
	persist_file -dv "$prefix"dead
	[ -L /live/rootfs/root/persist_file_tests/dead ] \
		&& error "deadlink not deleted (rootfs)"
	[ -L dead ] \
		&& error "deadlink not deleted (overlay)"

	ln -s ../d.triple/file d.double/link
	persist_file -v "$prefix"d.double/link
	[ "$(readlink /live/rootfs/root/persist_file_tests/d.double/link)" = ../d.triple/file ] \
		|| error "normal link"
	persist_file -dv "$prefix"d.double/link
	[ -L /live/rootfs/root/persist_file_tests/d.double/link ] \
		&& error "normal link not deleted (rootfs)"
	[ -L d.doubl/link ] \
		&& error "normal link not deleted (overlay)"

	ln -s ../d.triple/file d.double/link
	persist_file -vr "$prefix"d.double
	[ "$(readlink /live/rootfs/root/persist_file_tests/d.double/link)" = ../d.triple/file ] \
		|| error "normal link (dir)"
	persist_file -dvr "$prefix"d.double
	[ -L /live/rootfs/root/persist_file_tests/d.double/link ] \
		&& error "normal link not deleted (dir, rootfs)"
	[ -L d.doubl/link ] \
		&& error "normal link not deleted (dir, overlay)"
done
cd
persist_file -rd /root/persist_file_tests
