#!/bin/bash
# SPDX-License-Identifier: MIT

cd "$(dirname "$0")" || exit

error() {
	printf "%s\n" "$@" >&2
	exit 1
}

command -v afl-fuzz >/dev/null || error "Must have afl++ package installed"

afl-cc -o fuzz/schedule_ts -fsanitize=address -fsanitize=undefined ../../tools/schedule_ts.c

# don't care about cpufreq check
export AFL_SKIP_CPUFREQ=1

# also randomize start time?
afl-fuzz -i fuzz/inputs/ -o fuzz/outputs  -- ./fuzz/schedule_ts -B "2023-09-29 12:12:12" -


