#!/bin/bash

error() {
	printf "%s\n" "$@" >&2
	exit 1
}


cd "$(dirname "$0")" || error "cd test dir"

# prepare and clean test dir.
TESTDIR=$(mktemp -d /tmp/abos-base.mkbootscr.XXXXXX) \
	|| error "Could not create temp dir"
trap 'rm -rf "$TESTDIR"' EXIT

../tools/mkbootscr -T 0x62e9d658 mkbootscr.text "$TESTDIR/mkbootscr.scr" \
	|| error "mkbootscr failed"
cmp mkbootscr.scr "$TESTDIR/mkbootscr.scr" \
	|| error "output not as expected"

../tools/mkbootscr -q mkbootscr.text "$TESTDIR/mkbootscr.scr" \
	|| error "mkbootscr with real time failed"
cmp -s mkbootscr.scr "$TESTDIR/mkbootscr.scr" \
	&& error "output should not have been the same (very unlucky time in the past?)"

cp mkbootscr.text "$TESTDIR"
../tools/mkbootscr mkbootscr.scr "TESTDIR/mkbootscr.text" 2>/dev/null \
	&& error "mkbootscr should have failed"
cmp mkbootscr.text "$TESTDIR/mkbootscr.text" \
	|| error "mkbootscr should not have clobbered dest file on this failure"

rm -f "$TESTDIR/mkbootscr.scr"
../tools/mkbootscr "$TESTDIR/mkbootscr.text" \
	|| error "mkbootscr should guess output name"
[ -e "$TESTDIR/mkbootscr.scr" ] \
	|| error "should have created $TESTDIR/mkbootscr.scr"
rm -f "$TESTDIR/mkbootscr.scr"
mv "$TESTDIR/mkbootscr.text" "$TESTDIR/mkbootscr"
../tools/mkbootscr "$TESTDIR/mkbootscr" \
	|| error "mkbootscr should guess output name (2)"
[ -e "$TESTDIR/mkbootscr.scr" ] \
	|| error "should have created $TESTDIR/mkbootscr.scr (2)"


# need last command to be true-ish to not fail test
true
